<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Turista
 */
$turista_blog_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'turista_image_1200_800');
$turista_categories_list = get_the_category_list( esc_html__( ', ', 'turista' ) );
$turista_tags_list = get_the_tag_list( '', esc_html_x( ' # ', 'list item separator', 'turista' ) );
$turista_embede_code = get_post_meta(get_the_ID(), '_turista_embed_code', true); 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="single_blog blog-details">
	<?php if( $turista_embede_code){ ?>
		<div class="blog_embed_code">
			<?php echo turista_wp_kses($turista_embede_code);?>
		</div>	
	<?php }elseif( has_post_thumbnail() ){ ?>
		<div class="blog_image">
			<img class="blog-photo" alt="<?php echo esc_attr(get_the_title());?>" src="<?php echo esc_url($turista_blog_image['0']);?>"/>
		</div>
	<?php } ?>

		<div class="blog-text">	
			<h4><?php the_title();?></h4>		
			<div class="post-meta">	
				<span>
					<i class="icofont-clock-time"></i> <?php echo get_the_time('d M Y');?>
				</span>	

				<span>
					<i class="icofont-comment"></i> <?php comments_popup_link( '0 Comments', '1 Comment ', '% Comments ', 'comments-link', ' 0 Comments '); ?>
				</span>				
				<?php if($turista_categories_list){ ?>
					<span>
						<i class="icofont-tags"></i> <?php echo turista_wp_kses($turista_categories_list); ?>
					</span>
				<?php } ?>
			</div>
			<div class="post_description">	
				<?php the_content();?>
			</div>	
			<?php if($turista_tags_list){ ?>
				<div class="post_tags">
					# <?php echo turista_wp_kses($turista_tags_list);?>
				</div>
			<?php
			}
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'turista' ),
					'after'  => '</div>',
				) );
			?>
		</div>							
	</div>	
</article><!-- #post-<?php the_ID(); ?> -->