<?php 
/**
 * The template for displaying all single Tour
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Turista
 */
 
get_header();
turista_single_page_banner();
$related_spt_related_subtitle = get_post_meta(get_the_ID(), '_turista_spt_related_subtitle', true); 
$related_spt_related_title = get_post_meta(get_the_ID(), '_turista_spt_related_title', true); 
?>	

		<?php
		while ( have_posts() ) :
			the_post();

			get_template_part( 'template-parts/content', 'special-tour' );

		endwhile; // End of the loop.
		?>

	<!-- START DEALS & DISCOUNT -->
	<section class="related-deal section-padding">
		<div class="container">		
			<div class="row">
				<div class="col-md-12" data-aos="fade-up">
					<div class="section-title text-center white-title">
						<?php if($related_spt_related_subtitle){ ?>
							<span><?php echo esc_html($related_spt_related_subtitle);?></span>
						<?php } if($related_spt_related_title){ ?>
							<h2><?php echo turista_wp_kses($related_spt_related_title);?></h2>	
						<?php } ?>		
					</div>
				</div><!-- END COL -->
			</div><!-- END ROW -->	
			
			<div class="row text-left">
				<div class="col-md-12" data-aos="fade-up">
					<div id="package-slider">
					<?php
						// WP_Query arguments
						$args = array(
							'post_type'              => array( 'special_tour' ),
							'post__not_in' => array($post->ID),
							'posts_per_page'=> -1
						);

						// The Query
						$turista_spt_query = new WP_Query( $args );

						// The Loop
						if ( $turista_spt_query->have_posts() ) {
							while ( $turista_spt_query->have_posts() ) {
								$turista_spt_query->the_post();					
								$turista_spt_price = get_post_meta(get_the_ID(), '_turista_spt_price', true);
							?>
								<div class="single-deal">
									<figure class="effect-sadie ">
										<?php the_post_thumbnail('turista_image_1200_800');?>
										<figcaption>	
											<div class="pull-left">
												<h4><?php the_title();?></h4>
												<p><?php echo esc_html($turista_spt_price);?></p>
											</div>
											
											<div class="pull-right">
												<a href="<?php the_permalink();?>"><i class="icofont-arrow-right"></i></a>
											</div>	
										</figcaption>			
									</figure>
								</div><!--- END GRID -->			
							<?php
							}
						} else {
							// no posts found
						}

						// Restore original Post Data
						wp_reset_postdata();
					?>			

					</div>
				</div><!-- END COL -->
			</div><!-- END ROW -->
		</div><!-- END CONTAINER -->
	</section>
	<!-- END DEALS & DISCOUNT -->

<?php get_footer();?>	