<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaServiceWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-service';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Service' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_service',
			[
				'label' => esc_html__( 'Service', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	
		$this->add_control(
			'ser_icon',
			[
				'label' => esc_html__( 'Icon', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'icofont-bed',
			]
		);	
			
		$this->add_control(
			'ser_title',
			[
				'label' => esc_html__( 'Title', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => 'Hotel Booking',
			]
		);	
		
		$this->add_control(
			'ser_content',
			[
				'label' => esc_html__( 'Content', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA ,
				'default' => ' Lorem ipsum dolor sit amet consetetur sadipscing elitr sed diam nonumy eirmod tempor invidunt ',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$ser_icon = $this->get_settings_for_display( 'ser_icon' );
		$ser_title = $this->get_settings_for_display( 'ser_title' );
		$ser_content = $this->get_settings_for_display( 'ser_content' );
		
		?>

		<div class="service text-center" data-aos="fade-up">
			<div class="icon"><i class="<?php echo esc_attr($ser_icon);?>"></i></div>
			<h4><?php echo turista_wp_kses($ser_title);?></h4>
			<p>
				<?php echo turista_wp_kses($ser_content);?>
			</p>
		</div>
					
<?php
	}

}
