<?php

// File Security Check
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class TuristaClientWidget extends Elementor\Widget_Base{
	public function get_name() {
		
		return 'turista-client';
	}
	public function get_icon() {
		
		return 'eicon-site-title';
	}
	public function get_title() {
		return esc_html__('Client' , 'turista');
	}
	
	public function get_categories() {
		return ['turista-category'];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
		'turista_client',
			[
				'label' => esc_html__( 'Client', 'turista' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'client_nub_post',
			[
				'label' => esc_html__( 'Number of Posts', 'turista' ),
				'type' => \Elementor\Controls_Manager::TEXT ,
				'default' => '-1',
			]
		);		
		
		
		$this->end_controls_section();

	}
	
	protected function render(){		

		$client_nub_post = $this->get_settings_for_display( 'client_nub_post' );
		
		?>
		
		<!-- START COMPANY PARTNER LOGO  -->
		<div class="partner-logo">
			<div class="container">
				<div class="row">
					<div class="col-md-12" data-aos="fade-up">
						<div class="partner">
						
				<?php
					// WP_Query arguments
					$args = array(
						'post_type'              => array( 'client' ),
						'posts_per_page'         => $client_nub_post,
					);

					// The Query
					$turista_client_query = new WP_Query( $args );

					// The Loop
					if ( $turista_client_query->have_posts() ) {
						while ( $turista_client_query->have_posts() ) {
							$turista_client_query->the_post();					
							$turista_client_url = get_post_meta(get_the_ID(), '_turista_client_url', true);
					
						?>
	
						<a href="<?php echo esc_url($turista_client_url);?>"><?php the_post_thumbnail('turista_image_185_100');?></a>						
						
						<?php
						}
					} else {
						// no posts found
					}

					// Restore original Post Data
					wp_reset_postdata();
				?>	
				
	
						</div>
					</div><!-- END COL  -->
				</div><!--END  ROW  -->
			</div><!-- END CONTAINER  -->
		</div>
		<!-- END COMPANY PARTNER LOGO -->
		
	
		
		
<?php
	}

}
